<?php
/*
Plugin Name: WC Custom Redirect After Purchase
Description: Redirects customers to a specific page after completing a purchase.
Version: 1.0
Author: Ibrahim Ishaq
*/

// Ensure WooCommerce is active
if ( ! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    return;
}

// Function to handle the redirect after order received
function wc_custom_redirect_after_purchase( $order_id ) {
    // Check if there is an order ID
    if ( ! $order_id ) {
        return;
    }

    // Get order details
    $order = wc_get_order( $order_id );

    // Redirect URL
    $redirect_url = 'https://sity.cloud/dashboard/';

    // If the order was successful, redirect to the custom URL
    if ( $order->has_status( 'completed' ) || $order->has_status( 'processing' ) ) {
        wp_redirect( $redirect_url );
        exit;
    }
}
add_action( 'woocommerce_thankyou', 'wc_custom_redirect_after_purchase' );
